﻿using System;
using System.Configuration;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using gov.va.med.VBECS.Communication.Channels;
using gov.va.med.VBECS.Communication.Clients;
using gov.va.med.VBECS.Communication.Common;
using gov.va.med.VBECS.Communication.Utils;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages;

namespace ClientDemo.Demos
{
    public class VistaConnection : IClientDemo
    {
        public void Dispose()
        {
        }

        public void Start()
        {
            Console.WriteLine("Press enter to connect to the server...");
            Console.ReadLine(); //Wait user to press enter

            //Read server IP address/ Port
            var serverIp = ConfigurationManager.AppSettings.Get("ServerIP");
            var serverPort = ConfigurationManager.AppSettings.Get("ServerPort");

            using (var client = ClientFactory.CreateClient<MockPinger>(new IPEndPoint(IPAddress.Parse(serverIp), int.Parse(serverPort))))
            {
                client.Connect();

                client.MessageReceived += client_message_received;
                //client.Send(new VistALinkHeartbeatRequestMessage());
                do_start_blocking(client);
            }
        }

        protected virtual void do_start_blocking(IMessager client)
        {
            string filename = null;
            try
            {
                filename = ConfigurationManager.AppSettings.Get("InputMessage");
            }
            // ReSharper disable EmptyGeneralCatchClause
            catch { }
            // ReSharper restore EmptyGeneralCatchClause

                IMessage aMessage;
                if (filename == null)
                {
                    Console.Write("Write some message to be sent to server: ");
                    aMessage = new TextMessage(Console.ReadLine()); //Get a message from user
                }
                else
                {
                    if (!File.Exists(filename + ".txt"))
                    {
                        Console.Write("file doesn't exists: " + filename + ".txt");
                        Console.Write("Exist");
                        return;
                    }

                    Console.Write("Deserialize message from the file: " + filename + ".txt");
                    IMessageSerializer sr = new TextMessageSerializer();
                    aMessage = sr.DeSerializeObject(filename + ".txt");
                }

                IMessage message = null;
                try
                {
                    //Console.WriteLine("Start sending blocking message [{1}]: {0}", aMessage.Text, aMessage.Id);
                    int counter = 0;
                    while (counter++ < 100000)
                    {
                        Console.WriteLine("Send message #: " + counter);
                        client.Send(aMessage);
                        Thread.Sleep(100);
                    }
                }
                catch (Exception e)
                {
                    Console.WriteLine("Error message (blocking): " + e.Message);
                }
                /*if (message != null)
                    Console.WriteLine("Response to blocking message [{1}]: {0}",
                        new TextMessage(message.GetBytes()).Text, message.RepliedId);*/

        }

        static void client_message_received(object sender, MessageEventArgs e)
        {
            var message = e.Message as TextMessage; //Server only accepts text messages
            if (message == null && e.Message is RawDataMessage)
            {
                // Try to construct message from RawMessage
                message = new TextMessage(((RawDataMessage)e.Message).Data);
            }
            if (message == null) return;

            Console.WriteLine("Response from messager: " + message.Text);
        }
    }
}
